@echo off
chcp 65001 >nul
title Installation Order and Chaos - GPO
color 0A

echo ========================================
echo   INSTALLATION ORDER AND CHAOS - GPO
echo ========================================
echo.

REM Vérifier si ADB existe dans le dossier
if not exist "platform-tools\adb.exe" (
    echo [ERREUR] ADB n'est pas trouvé dans le dossier platform-tools!
    echo.
    echo Veuillez télécharger les Platform Tools depuis:
    echo https://developer.android.com/studio/releases/platform-tools
    echo.
    echo Extrayez le contenu dans le dossier "platform-tools"
    pause
    exit /b 1
)

set ADB=platform-tools\adb.exe

REM Vérifier si l'APK existe
if not exist "Order-And-Chaos-Official-Gpo.apk" (
    echo [ERREUR] Le fichier APK n'est pas trouvé!
    echo Assurez-vous que "Order-And-Chaos-Official-Gpo.apk" est dans ce dossier.
    pause
    exit /b 1
)

echo [1/5] Démarrage du serveur ADB...
%ADB% start-server >nul 2>&1
timeout /t 2 /nobreak >nul

echo [2/5] Recherche d'appareils connectés...
%ADB% devices > devices_temp.txt
findstr /v "List" devices_temp.txt | findstr /v "^$" > devices_count.txt

set DEVICE_COUNT=0
for /f %%i in (devices_count.txt) do set /a DEVICE_COUNT+=1

del devices_temp.txt devices_count.txt

if %DEVICE_COUNT%==0 (
    echo.
    echo [ERREUR] Aucun appareil Android détecté!
    echo.
    echo Assurez-vous que:
    echo  - Le débogage USB est activé sur votre appareil
    echo  - L'appareil est connecté via USB
    echo  - Vous avez autorisé le débogage USB sur l'appareil
    echo.
    pause
    exit /b 1
)

echo [OK] Appareil détecté!
echo.

echo [3/5] Informations de l'appareil:
%ADB% shell getprop ro.product.model
%ADB% shell getprop ro.build.version.release
echo.

echo [4/5] Installation de l'APK en cours...
echo Cette étape peut prendre quelques instants...
echo.

REM Installation avec options pour contourner les restrictions de SDK
%ADB% install -r -d --bypass-low-target-sdk-block Order-And-Chaos-Official-Gpo.apk

if %ERRORLEVEL% EQU 0 (
    echo.
    echo [5/5] ========================================
    echo [SUCCÈS] Installation terminée avec succès!
    echo ========================================
    echo.
    echo L'application est maintenant installée sur votre appareil.
    echo Vous pouvez la lancer depuis le menu des applications.
    echo.
) else (
    echo.
    echo [ERREUR] L'installation a échoué!
    echo.
    echo Tentative avec des paramètres alternatifs...
    %ADB% install -r -t -d Order-And-Chaos-Official-Gpo.apk
    
    if %ERRORLEVEL% EQU 0 (
        echo.
        echo [SUCCÈS] Installation réussie avec méthode alternative!
        echo.
    ) else (
        echo.
        echo [ERREUR] L'installation a échoué. Raisons possibles:
        echo  - L'application est déjà installée (essayez de la désinstaller d'abord)
        echo  - Permissions insuffisantes
        echo  - Incompatibilité avec votre version d'Android
        echo.
    )
)

pause